/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice;

import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.android.invoice.domain.InvoiceMapper;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.use_case.invoice.BuildAInvoiceDtl;
import com.android.payment.domain.use_case.GetInvoiceChequesUseCase;
import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class QueryInvoices {
    private final DbConnection dbConnection;
    @Resource
    @Lazy
    private BuildAInvoiceDtl buildAInvoiceDtl;
    @Resource
    @Lazy
    private GetInvoiceChequesUseCase invoiceChequesUseCase;

    public List<AInvoiceDto> invoke(String sql, LoginDto login, RequestData request) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        List dtoList = jdbc.query(sql, (RowMapper)new InvoiceMapper());
        List dtlList = this.buildAInvoiceDtl.invoke(login, dtoList.stream().map(AInvoiceDto::getServerId).collect(Collectors.toList()), new AndroidFilter(request, QueryParamTypes.INVOICE).makeUserParamMap(false));
        List chequeList = this.invoiceChequesUseCase.invoke(this.dbConnection.getJdbcTemplate());
        return dtoList.stream().peek(dto -> {
            dto.setDtlDto(dtlList.stream().filter(dtl -> dtl.getInvoiceId().equals(dto.getServerId()) && dtl.getTypeChar().equals(dto.getTypeChar())).collect(Collectors.toList()));
            dto.setChequeList(chequeList.stream().filter(checkDto -> checkDto.getFactureId().equals(dto.getId())).collect(Collectors.toList()));
        }).collect(Collectors.toList());
    }

    public QueryInvoices(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

